﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Remoting;

namespace Server
{
	class ServerActionHandler : RActionHandler
	{
		private readonly object lockObj = new object();

		private List<RMessagePipe> Pipes = new List<RMessagePipe>();

		public override void Do(string method, params object[] args)
		{
			Console.WriteLine("Invoke: {0} with args {1}", method, ToString(args));
			lock (lockObj)
			{
				// process action

				// inform other clients, if one client fails, remove it
				List<RMessagePipe> toUnregister = new List<RMessagePipe>();
				foreach (RMessagePipe pipe in Pipes)
				{
					try
					{
						pipe.SendMessage(new RMessage(method, args));
					}
					catch (Exception ex)
					{
						Console.WriteLine("Caught client exception at client {0}: {1}", pipe, ex);
						toUnregister.Add(pipe);
					}
				}
				// unregister broken pipes
				foreach (RMessagePipe pipe in toUnregister)
				{
					Unregister(pipe);
				}
			}
		}

		private string ToString(object[] args)
		{
			StringBuilder result = new StringBuilder();
			bool first = true;
			foreach (object arg in args)
			{
				if (!first)
					result.Append(", ");
				first = false;
				result.AppendFormat("{0}", arg);
			}
			return result.ToString();
		}

		public void Register(RMessagePipe clientPipe)
		{
			lock (lockObj)
			{
				Pipes.Add(clientPipe);
			}
		}

		public void Unregister(RMessagePipe clientPipe)
		{
			lock (lockObj)
			{
				Pipes.Remove(clientPipe);
			}
		}

		public bool HasFreeSlots()
		{
			lock (lockObj)
			{
				if (Pipes.Count >= 5)
				{
					return false;
				}
				return true;
			}
		}
	}
}
